# scamper python interface
#
# Authors: Matthew Luckie, Ken Keys
#
# Copyright (C) 2025 The Regents of the University of California
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from typing import (cast, Callable, Dict, Generator, Iterator, List,
                    Optional, Set, Sequence, Tuple, Type, TypeAlias,
                    TypeVar, Union, Generic)
from builtins import BaseException
import datetime
import enum
import types

class ScamperAddr:
    def __init__(self, addr: Union[str, bytes]) -> None: ...
    def __lt__(self, other: Union["ScamperAddr", str]) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __str__(self) -> str: ...
    def __hash__(self) -> int: ...
    def __getstate__(self) -> dict: ...
    def __setstate__(self, state: dict) -> None: ...

    @property
    def packed(self) -> Optional[bytes]: ...

    def is_linklocal(self) -> bool: ...
    def is_rfc1918(self) -> bool: ...
    def is_unicast(self) -> bool: ...
    def is_6to4(self) -> bool: ...
    def is_ipv4(self) -> bool: ...
    def is_ipv6(self) -> bool: ...
    def is_reserved(self) -> bool: ...

class ScamperCycle:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: Union["ScamperCycle", str]) -> bool: ...
    def __eq__(self, other: object) -> bool: ...

    @property
    def id(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    @property
    def stop(self) -> Optional[datetime.datetime]: ...

    @property
    def hostname(self) -> Optional[str]: ...

class ScamperList:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: Union["ScamperAddr", str]) -> bool: ...
    def __eq__(self, other: object) -> bool: ...

    @property
    def id(self) -> Optional[int]: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def descr(self) -> Optional[str]: ...

    @property
    def monitor(self) -> Optional[str]: ...

class ScamperVp:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def shortname(self) -> Optional[str]: ...

    @property
    def tags(self) -> Set[str]: ...

    @property
    def asn4(self) -> Union[int, str, None]: ...

    @property
    def ipv4(self) -> Optional[str]: ...

    @property
    def loc(self) -> Optional[Tuple[float, float]]: ...

    @property
    def iata(self) -> Optional[str]: ...

    @property
    def cc(self) -> Optional[str]: ...

    @property
    def st(self) -> Optional[str]: ...

    @property
    def place(self) -> Optional[str]: ...

class ScamperTask:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: "ScamperTask") -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __str__(self) -> str: ...

    def halt(self) -> None: ...

class ScamperInst:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: "ScamperInst") -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __str__(self) -> str: ...
    def __hash__(self) -> int: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def shortname(self) -> Optional[str]: ...

    @property
    def asn4(self) -> Union[int, str, None]: ...

    @property
    def ipv4(self) -> Optional[str]: ...

    @property
    def loc(self) -> Optional[Tuple[float, float]]: ...

    @property
    def iata(self) -> Optional[str]: ...

    @property
    def cc(self) -> Optional[str]: ...

    @property
    def st(self) -> Optional[str]: ...

    @property
    def place(self) -> Optional[str]: ...

    @property
    def taskc(self) -> int: ...

    @property
    def resultc(self) -> int: ...

    def done(self) -> None: ...
    def is_eof(self) -> bool: ...

class ScamperInstError(Exception):
    def __init__(self, message: str, inst: ScamperInst) -> None: ...
    inst: ScamperInst

class ScamperMux:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def vps(self) -> List[ScamperVp]: ...

class ScamperIcmpMplsLabelStackEntry:
    def __init__(self, ext: "ScamperIcmpExt", i: int) -> None: ...

    @property
    def label(self) -> int: ...

    @property
    def exp(self) -> int: ...

    @property
    def s(self) -> int: ...

    @property
    def ttl(self) -> int: ...

class ScamperIcmpExt:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: "ScamperInst") -> bool: ...
    def __eq__(self, other: object) -> bool: ...

    def is_mpls(self) -> bool: ...

    @property
    def mpls_count(self) -> int: ...
    def mpls_lses(self) -> Optional[Iterator[ScamperIcmpMplsLabelStackEntry]]: ...
    def mpls_lse(self, i: int) -> Optional[ScamperIcmpMplsLabelStackEntry]: ...
    def mpls_label(self, i: int) -> Optional[int]: ...
    def mpls_ttl(self, i: int) -> Optional[int]: ...
    def mpls_exp(self, i: int) -> Optional[int]: ...
    def mpls_s(self, i: int) -> Optional[int]: ...

class ScamperIcmpExts:
    def __init__(self, *args: object, **kwargs: object) -> None: ...
    def __lt__(self, other: "ScamperInst") -> bool: ...
    def __eq__(self, other: object) -> bool: ...

    @property
    def ext_count(self) -> int: ...
    def ext(self, i: int) -> Optional[ScamperIcmpExt]: ...
    def exts(self) -> Iterator[ScamperIcmpExt]: ...

    @property
    def mpls(self) -> Optional[ScamperIcmpExt]: ...

class ScamperDealiasProbedef:
    def __init__(self,
                 method: str,
                 src: Union[str, ScamperAddr, None] = ...,
                 dst: Union[str, ScamperAddr, None] = ...,
                 ttl: Optional[int] = ...,
                 size: Optional[int] = ...,
                 sport: Optional[int] = ...,
                 dport: Optional[int] = ...,
                 icmp_id: Optional[int] = ...,
                 icmp_sum: Optional[int] = ...
                 ) -> None: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def ttl(self) -> int: ...

    @property
    def size(self) -> int: ...

    @property
    def sport(self) -> Optional[int]: ...

    @property
    def dport(self) -> Optional[int]: ...

    @property
    def icmp_id(self) -> Optional[int]: ...

    @property
    def icmp_sum(self) -> Optional[int]: ...

    def is_udp(self) -> bool: ...
    def is_icmp(self) -> bool: ...
    def is_tcp(self) -> bool: ...

class ScamperDealiasReply:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def rx(self) -> Optional[datetime.datetime]: ...

    @property
    def ttl(self) -> int: ...

    @property
    def size(self) -> int: ...

    @property
    def tcp_flags(self) -> Optional[int]: ...

    @property
    def icmp_type(self) -> Optional[int]: ...

    @property
    def icmp_code(self) -> Optional[int]: ...

    @property
    def icmp_q_ttl(self) -> Optional[int]: ...

    @property
    def ipid(self) -> Optional[int]: ...

    def is_tcp(self) -> bool: ...
    def is_icmp(self) -> bool: ...
    def is_icmp_ttl_exp(self) -> bool: ...
    def is_icmp_unreach(self) -> bool: ...
    def is_icmp_unreach_port(self) -> bool: ...
    def is_icmp_echo_reply(self) -> bool: ...
    def is_from_target(self) -> bool: ...

class ScamperDealiasProbe:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def probedef(self) -> ScamperDealiasProbedef: ...

    @property
    def ipid(self) -> int: ...

    @property
    def seq(self) -> int: ...

    @property
    def tx(self) -> Optional[datetime.datetime]: ...

    @property
    def reply_count(self) -> int: ...
    def reply(self, i: Optional[int] = ...) -> Optional[ScamperDealiasReply]: ...
    def replies(self) -> Iterator[ScamperDealiasReply]: ...

class ScamperDealiasMidardiscRound:
    def __init__(self, start: datetime.timedelta, begin: int, end: int) -> None: ...

    @property
    def start(self) -> datetime.timedelta: ...

    @property
    def begin(self) -> int: ...

    @property
    def end(self) -> int: ...

class ScamperDealias:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    @property
    def startat(self) -> Optional[datetime.datetime]: ...

    @property
    def wait_probe(self) -> Optional[datetime.timedelta]: ...

    @property
    def wait_round(self) -> Optional[datetime.timedelta]: ...

    @property
    def wait_timeout(self) -> Optional[datetime.timedelta]: ...

    def to_json(self) -> Optional[str]: ...
    def to_text(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    def is_ally(self) -> bool: ...
    def is_mercator(self) -> bool: ...
    def is_prefixscan(self) -> bool: ...
    def is_radargun(self) -> bool: ...
    def is_bump(self) -> bool: ...
    def is_midarest(self) -> bool: ...
    def is_midardisc(self) -> bool: ...

    def has_aliases(self) -> bool: ...
    def aliases(self) -> Tuple[ScamperAddr, ScamperAddr]: ...

    @property
    def probedef_count(self) -> Optional[int]: ...
    def probedef(self, i: Optional[int] = ...) -> Optional[ScamperDealiasProbedef]: ...
    def probedefs(self) -> Iterator[ScamperDealiasProbedef]: ...

    @property
    def probe_count(self) -> int: ...
    def probe(self, i: Optional[int] = ...) -> Optional[ScamperDealiasProbe]: ...
    def probes(self) -> Iterator[ScamperDealiasProbe]: ...

class ScamperHostType(enum.IntEnum):
    A = 1
    NS = 2
    CNAME = 5
    SOA = 6
    PTR = 12
    MX = 15
    TXT = 16
    AAAA = 28
    DS = 43
    SSHFP = 44
    RRSIG = 46
    NSEC = 47
    DNSKEY = 48

class ScamperHostStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Completed = cast(int, ...)
    Timeout = cast(int, ...)
    Halted = cast(int, ...)
    Error = cast(int, ...)

class ScamperHostOPTElem:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def code_num(self) -> int: ...

    @property
    def code(self) -> str: ...

    @property
    def data(self) -> Optional[bytes]: ...

class ScamperHostOPT:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperHostOPTElem]: ...
    def __next__(self) -> ScamperHostOPTElem: ...

    @property
    def elemc(self) -> int: ...
    def elem(self, i: int) -> Optional[ScamperHostOPTElem]: ...

class ScamperHostMX:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def pref(self) -> int: ...

    @property
    def exch(self) -> Optional[str]: ...

class ScamperHostSOA:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def mname(self) -> Optional[str]: ...

    @property
    def rname(self) -> Optional[str]: ...

    @property
    def serial(self) -> int: ...

    @property
    def refresh(self) -> int: ...

    @property
    def retry(self) -> int: ...

    @property
    def expire(self) -> int: ...

    @property
    def minimum(self) -> int: ...

class ScamperHostSVCBParam:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def key_num(self) -> int: ...

    @property
    def key(self) -> str: ...

    @property
    def val(self) -> Optional[bytes]: ...

class ScamperHostSVCB:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperHostSVCBParam]: ...
    def __next__(self) -> ScamperHostSVCBParam: ...

    @property
    def target(self) -> Optional[str]: ...

    @property
    def priority(self) -> int: ...

    @property
    def paramc(self) -> int: ...
    def param(self, i: int) -> Optional[ScamperHostSVCBParam]: ...

class ScamperHostTXT:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[str]: ...
    def __next__(self) -> str: ...

    @property
    def strc(self) -> int: ...
    def str(self, i: int) -> Optional[str]: ...

class ScamperHostRR:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def rclass(self) -> int: ...

    @property
    def rtype(self) -> int: ...

    @property
    def ttl(self) -> int: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def addr(self) -> Optional[ScamperAddr]: ...

    @property
    def ns(self) -> Optional[str]: ...

    @property
    def cname(self) -> Optional[str]: ...

    @property
    def ptr(self) -> Optional[str]: ...

    @property
    def mx(self) -> Optional[ScamperHostMX]: ...

    @property
    def soa(self) -> Optional[ScamperHostSOA]: ...

    @property
    def txt(self) -> Optional[ScamperHostTXT]: ...

    @property
    def opt(self) -> Optional[ScamperHostOPT]: ...

    @property
    def svcb(self) -> Optional[ScamperHostSVCB]: ...

    @property
    def udpsize(self) -> Optional[int]: ...

    @property
    def edns_version(self) -> Optional[int]: ...

    @property
    def edns_do(self) -> Optional[bool]: ...

class ScamperHostQuery:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def tx(self) -> Optional[datetime.datetime]: ...

    @property
    def rx(self) -> Optional[datetime.datetime]: ...

    @property
    def rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def rcode_num(self) -> Optional[int]: ...

    @property
    def rcode(self) -> Optional[str]: ...

    @property
    def extended_rcode_num(self) -> Optional[int]: ...

    @property
    def extended_rcode(self) -> Optional[str]: ...

    @property
    def flags(self) -> int: ...

    @property
    def id(self) -> int: ...

    @property
    def ancount(self) -> int: ...
    def an(self, i: int) -> Optional[ScamperHostRR]: ...

    @property
    def nscount(self) -> int: ...
    def ns(self, i: int) -> Optional[ScamperHostRR]: ...

    @property
    def arcount(self) -> int: ...
    def ar(self, i: int) -> Optional[ScamperHostRR]: ...

    @property
    def udpsize(self) -> Optional[int]: ...

    @property
    def edns_version(self) -> Optional[int]: ...

    @property
    def edns_do(self) -> Optional[bool]: ...

class ScamperHost:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    def to_json(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def stop_reason(self) -> ScamperHostStop: ...

    @property
    def stop_reason_str(self) -> str: ...

    @property
    def qtype_num(self) -> int: ...

    @property
    def qtype(self) -> str: ...

    @property
    def qclass(self) -> str: ...

    @property
    def qname(self) -> str: ...

    @property
    def ecs(self) -> str: ...

    @property
    def rcode_num(self) -> Optional[int]: ...

    @property
    def rcode(self) -> Optional[str]: ...

    @property
    def extended_rcode_num(self) -> Optional[int]: ...

    @property
    def extended_rcode(self) -> Optional[str]: ...

    @property
    def tx(self) -> Optional[datetime.datetime]: ...

    @property
    def rx(self) -> Optional[datetime.datetime]: ...

    @property
    def rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def udpsize(self) -> Optional[int]: ...

    @property
    def edns_version(self) -> Optional[int]: ...

    @property
    def edns_do(self) -> Optional[bool]: ...

    @property
    def ancount(self) -> int: ...
    def ans(self, rrtypes: Optional[List[str]] = ...) -> Iterator[ScamperHostRR]: ...
    def an(self, i: int) -> Optional[ScamperHostRR]: ...

    @property
    def nscount(self) -> int: ...
    def nss(self, rrtypes: Optional[List[str]] = ...) -> Iterator[ScamperHostRR]: ...
    def ns(self, i: int) -> Optional[ScamperHostRR]: ...

    @property
    def arcount(self) -> int: ...
    def ars(self, rrtypes: Optional[List[str]] = ...) -> Iterator[ScamperHostRR]: ...
    def ar(self, i: int) -> Optional[ScamperHostRR]: ...

    def ans_addrs(self) -> List[ScamperAddr]: ...
    def ans_nses(self) -> List[str]: ...
    def ans_ptrs(self) -> List[str]: ...
    def ans_txts(self) -> List[ScamperHostTXT]: ...
    def ans_mxes(self) -> List[ScamperHostMX]: ...

class ScamperHttpStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Halted = cast(int, ...)
    NoConnection = cast(int, ...)
    Completed = cast(int, ...)
    Error = cast(int, ...)
    Timeout = cast(int, ...)
    Insecure = cast(int, ...)

class ScamperHttpBuf:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def timestamp(self) -> Optional[datetime.datetime]: ...

    @property
    def dir_str(self) -> str: ...

    @property
    def type_str(self) -> str: ...

    @property
    def payload(self) -> Optional[bytes]: ...

    def is_tx(self) -> bool: ...
    def is_rx(self) -> bool: ...
    def is_tls(self) -> bool: ...
    def is_hdr(self) -> bool: ...
    def is_data(self) -> bool: ...

class ScamperHttp:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def userid(self) -> int: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    @property
    def stop_reason(self) -> ScamperHttpStop: ...

    @property
    def stop_reason_str(self) -> str: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def sport(self) -> int: ...

    @property
    def dport(self) -> int: ...

    @property
    def url(self) -> Optional[str]: ...

    @property
    def status_code(self) -> Optional[int]: ...

    @property
    def response(self) -> Optional[bytes]: ...

    @property
    def response_hdr(self) -> Optional[str]: ...
    def response_hdr_byname(self, name: str) -> Optional[str]: ...

    @property
    def response_hdrs(self) -> Optional[Dict[str, str]]: ...

    @property
    def transmit_hdr(self) -> Optional[str]: ...
    def transmit_hdr_byname(self, name: str) -> Optional[str]: ...

    @property
    def transmit_hdrs(self) -> Optional[Dict[str, str]]: ...

    @property
    def buf_count(self) -> int: ...
    def buf(self, i: int) -> Optional[ScamperHttpBuf]: ...
    def bufs(self) -> Iterator[ScamperHttpBuf]: ...

class ScamperNeighbourdisc:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    def to_json(self) -> Optional[str]: ...

class ScamperPingStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Completed = cast(int, ...)
    Error = cast(int, ...)
    Halted = cast(int, ...)
    InProgress = cast(int, ...)

class ScamperPingReply:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def is_from_target(self) -> bool: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def tx(self) -> Optional[datetime.datetime]: ...

    @property
    def rx(self) -> Optional[datetime.datetime]: ...

    @property
    def rtt(self) -> datetime.timedelta: ...

    @property
    def attempt(self) -> int: ...

    @property
    def probe_ipid(self) -> Optional[int]: ...

    @property
    def reply_proto(self) -> int: ...

    @property
    def reply_ttl(self) -> Optional[int]: ...

    @property
    def reply_size(self) -> int: ...

    @property
    def reply_ipid(self) -> Optional[int]: ...

    def is_icmp(self) -> bool: ...
    def is_tcp(self) -> bool: ...
    def is_udp(self) -> bool: ...
    def is_icmp_echo_reply(self) -> bool: ...
    def is_icmp_unreach(self) -> bool: ...
    def is_icmp_unreach_port(self) -> bool: ...
    def is_icmp_ttl_exp(self) -> bool: ...
    def is_icmp_tsreply(self) -> bool: ...
    def is_icmp_ptb(self) -> bool: ...

    @property
    def icmp_type(self) -> Optional[int]: ...

    @property
    def icmp_code(self) -> Optional[int]: ...

    @property
    def icmp_nhmtu(self) -> Optional[int]: ...

    @property
    def tcp_flags(self) -> Optional[int]: ...

    @property
    def ifname(self) -> Optional[str]: ...

class ScamperPing:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def rtr(self) -> Optional[ScamperAddr]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    def to_json(self) -> Optional[str]: ...
    def to_text(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def stop_reason(self) -> ScamperPingStop: ...

    @property
    def stop_reason_str(self) -> str: ...

    @property
    def attempts(self) -> int: ...

    @property
    def probe_size(self) -> int: ...

    @property
    def payload(self) -> Optional[bytes]: ...

    def is_icmp(self) -> bool: ...
    def is_icmp_time(self) -> bool: ...
    def is_tcp(self) -> bool: ...
    def is_tcp_ack_sport(self) -> bool: ...
    def is_udp(self) -> bool: ...
    def is_vary_sport(self) -> bool: ...
    def is_vary_dport(self) -> bool: ...

    @property
    def probe_ttl(self) -> int: ...

    @property
    def probe_tos(self) -> int: ...

    @property
    def probe_sport(self) -> Optional[int]: ...

    @property
    def probe_dport(self) -> Optional[int]: ...

    @property
    def probe_icmp_sum(self) -> Optional[int]: ...

    @property
    def probe_tcp_seq(self) -> Optional[int]: ...

    @property
    def probe_tcp_ack(self) -> Optional[int]: ...

    @property
    def stop_count(self) -> int: ...

    @property
    def reply_pmtu(self) -> int: ...

    @property
    def probe_count(self) -> int: ...

    @property
    def wait_probe(self) -> datetime.timedelta: ...

    @property
    def wait_timeout(self) -> datetime.timedelta: ...

    def reply(self, i: int) -> Optional[ScamperPingReply]: ...
    def replies(self) -> Iterator[ScamperPingReply]: ...

    @property
    def nreplies(self) -> Optional[int]: ...

    @property
    def ndups(self) -> Optional[int]: ...

    @property
    def nloss(self) -> Optional[int]: ...

    @property
    def nerrs(self) -> Optional[int]: ...

    @property
    def min_rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def max_rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def avg_rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def stddev_rtt(self) -> Optional[datetime.timedelta]: ...

class ScamperSniffStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Error = cast(int, ...)
    LimitTime = cast(int, ...)
    LimitPktC = cast(int, ...)
    Halted = cast(int, ...)

class ScamperSniffPkt:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def rx(self) -> Optional[datetime.datetime]: ...

    @property
    def data(self) -> Optional[bytes]: ...

class ScamperSniff:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperSniffPkt]: ...
    def __next__(self) -> ScamperSniffPkt: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def stop_reason(self) -> ScamperSniffStop: ...

    @property
    def userid(self) -> int: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    @property
    def finish(self) -> Optional[datetime.datetime]: ...

    @property
    def limit_pkt_count(self) -> int: ...

    @property
    def limit_time(self) -> datetime.timedelta: ...

    @property
    def icmp_id(self) -> int: ...

    @property
    def pkt_count(self) -> int: ...
    def pkt(self, i: int = ...) -> Optional[ScamperSniffPkt]: ...

class ScamperSting:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

class ScamperTbitPkt:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def timestamp(self) -> Optional[datetime.datetime]: ...

    def is_tx(self) -> bool: ...
    def is_rx(self) -> bool: ...

    @property
    def data(self) -> Optional[bytes]: ...

class ScamperTbit:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperTbitPkt]: ...
    def __next__(self) -> ScamperTbitPkt: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    def to_json(self) -> Optional[str]: ...
    def to_text(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def result(self) -> str: ...

    @property
    def pkt_count(self) -> int: ...

    @property
    def client_mss(self) -> int: ...

    @property
    def client_wscale(self) -> int: ...

    @property
    def client_ipttl(self) -> int: ...

class ScamperTraceStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Completed = cast(int, ...)
    Unreach = cast(int, ...)
    Icmp = cast(int, ...)
    Loop = cast(int, ...)
    GapLimit = cast(int, ...)
    Error = cast(int, ...)
    HopLimit = cast(int, ...)
    GSS = cast(int, ...)
    Halted = cast(int, ...)
    InProgress = cast(int, ...)

class ScamperTraceHop:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def tx(self) -> Optional[datetime.datetime]: ...

    @property
    def rtt(self) -> Optional[datetime.timedelta]: ...

    @property
    def attempt(self) -> Optional[int]: ...

    @property
    def probe_ttl(self) -> Optional[int]: ...

    @property
    def probe_size(self) -> Optional[int]: ...

    @property
    def reply_ttl(self) -> Optional[int]: ...

    @property
    def reply_tos(self) -> Optional[int]: ...

    @property
    def icmp_type(self) -> Optional[int]: ...

    @property
    def icmp_code(self) -> Optional[int]: ...

    @property
    def reply_size(self) -> Optional[int]: ...

    @property
    def reply_ipid(self) -> Optional[int]: ...

    def is_tcp(self) -> bool: ...
    def is_icmp(self) -> bool: ...
    def is_icmp_q(self) -> bool: ...
    def is_icmp_unreach_port(self) -> bool: ...
    def is_icmp_echo_reply(self) -> bool: ...
    def is_icmp_ttl_exp(self) -> bool: ...
    def is_icmp_ptb(self) -> bool: ...

    @property
    def icmp_nhmtu(self) -> Optional[int]: ...

    @property
    def icmp_q_ttl(self) -> Optional[int]: ...

    @property
    def icmp_q_tos(self) -> Optional[int]: ...

    @property
    def icmp_q_ipl(self) -> Optional[int]: ...

    @property
    def tcp_flags(self) -> Optional[int]: ...

    @property
    def icmp_exts(self) -> Optional[ScamperIcmpExts]: ...

class ScamperTracePmtudNote:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def type_str(self) -> str: ...

    @property
    def nhmtu(self) -> int: ...

    @property
    def distance(self) -> int: ...

    def hop(self) -> Optional[ScamperTraceHop]: ...

class ScamperTracePmtud:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def path_mtu(self) -> int: ...

    @property
    def if_mtu(self) -> int: ...

    @property
    def out_mtu(self) -> int: ...

    def notes(self) -> Generator[ScamperTracePmtudNote, None, None]: ...

class ScamperTrace:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    def to_json(self) -> Optional[str]: ...
    def to_text(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def stop_reason(self) -> ScamperTraceStop: ...

    @property
    def stop_reason_str(self) -> str: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def rtr(self) -> Optional[ScamperAddr]: ...

    @property
    def hop_count(self) -> int: ...
    def hop(self, i: int) -> Optional[ScamperTraceHop]: ...
    def hops(self) -> Iterator[ScamperTraceHop]: ...

    @property
    def stop_hop(self) -> int: ...

    def addrs(self, reserved: bool = ...) -> Set[ScamperAddr]: ...

    @property
    def attempts(self) -> int: ...

    @property
    def hoplimit(self) -> int: ...

    @property
    def squeries(self) -> int: ...

    @property
    def gaplimit(self) -> int: ...

    @property
    def gapaction(self) -> int: ...

    @property
    def firsthop(self) -> int: ...

    @property
    def tos(self) -> int: ...

    @property
    def wait_probe(self) -> datetime.timedelta: ...

    @property
    def wait_timeout(self) -> datetime.timedelta: ...

    @property
    def confidence(self) -> int: ...

    @property
    def probe_size(self) -> int: ...

    @property
    def payload(self) -> Optional[bytes]: ...

    @property
    def probe_sport(self) -> Optional[int]: ...

    @property
    def probe_dport(self) -> Optional[int]: ...

    @property
    def probe_icmp_sum(self) -> Optional[int]: ...

    @property
    def offset(self) -> int: ...

    @property
    def probe_count(self) -> int: ...

    @property
    def pmtud(self) -> Optional[ScamperTracePmtud]: ...

    def is_udp(self) -> bool: ...
    def is_tcp(self) -> bool: ...
    def is_icmp(self) -> bool: ...
    def is_stop_noreason(self) -> bool: ...
    def is_stop_completed(self) -> bool: ...
    def is_stop_unreach(self) -> bool: ...
    def is_stop_icmp(self) -> bool: ...
    def is_stop_loop(self) -> bool: ...
    def is_stop_gaplimit(self) -> bool: ...
    def is_stop_error(self) -> bool: ...
    def is_stop_hoplimit(self) -> bool: ...
    def is_stop_gss(self) -> bool: ...
    def is_stop_halted(self) -> bool: ...

class ScamperTracelbMethod(enum.IntEnum):
    UdpDport = cast(int, ...)
    IcmpEcho = cast(int, ...)
    UdpSport = cast(int, ...)
    TcpSport = cast(int, ...)
    TcpAckSport = cast(int, ...)

class ScamperTracelbReply:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def rx(self) -> datetime.datetime: ...

    @property
    def ipid(self) -> Optional[int]: ...

    @property
    def ttl(self) -> Optional[int]: ...

    @property
    def icmp_type(self) -> Optional[int]: ...

    @property
    def icmp_code(self) -> Optional[int]: ...

    @property
    def icmp_q_ttl(self) -> Optional[int]: ...

    @property
    def icmp_q_tos(self) -> Optional[int]: ...

    @property
    def tcp_flags(self) -> Optional[int]: ...

    @property
    def icmp_exts(self) -> Optional[ScamperIcmpExts]: ...

class ScamperTracelbProbe:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def tx(self) -> datetime.datetime: ...

    @property
    def flowid(self) -> int: ...

    @property
    def ttl(self) -> int: ...

    @property
    def attempt(self) -> int: ...

    @property
    def reply_count(self) -> int: ...
    def reply(self, i: int) -> Optional[ScamperTracelbReply]: ...

class ScamperTracelbProbeset:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperTracelbProbe]: ...
    def __next__(self) -> ScamperTracelbProbe: ...

    @property
    def probe_count(self) -> int: ...
    def probe(self, i: int) -> Optional[ScamperTracelbProbe]: ...

class ScamperTracelbLink:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def near(self) -> Optional["ScamperTracelbNode"]: ...

    @property
    def far(self) -> Optional["ScamperTracelbNode"]: ...

    @property
    def length(self) -> int: ...

    def probeset(self, i: int) -> Optional[ScamperTracelbProbeset]: ...

class ScamperTracelbNode:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def name(self) -> Optional[str]: ...

    @property
    def icmp_q_ttl(self) -> Optional[int]: ...

    @property
    def link_count(self) -> int: ...
    def link(self, i: int) -> Optional[ScamperTracelbLink]: ...
    def links(self) -> Iterator[ScamperTracelbLink]: ...

class ScamperTracelb:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def method(self) -> ScamperTracelbMethod: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> Optional[datetime.datetime]: ...

    def to_json(self) -> Optional[str]: ...
    def to_text(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def rtr(self) -> Optional[ScamperAddr]: ...

    @property
    def node_count(self) -> int: ...
    def node(self, i: int) -> Optional[ScamperTracelbNode]: ...
    def nodes(self) -> Iterator[ScamperTracelbNode]: ...

    @property
    def link_count(self) -> int: ...
    def link(self, i: int) -> Optional[ScamperTracelbLink]: ...
    def links(self) -> Iterator[ScamperTracelbLink]: ...

    @property
    def attempts(self) -> int: ...

    @property
    def gaplimit(self) -> int: ...

    @property
    def firsthop(self) -> int: ...

    @property
    def tos(self) -> int: ...

    @property
    def wait_probe(self) -> datetime.timedelta: ...

    @property
    def wait_timeout(self) -> datetime.timedelta: ...

    @property
    def confidence(self) -> int: ...

    @property
    def probe_count(self) -> int: ...

    @property
    def probe_size(self) -> int: ...

    @property
    def probe_sport(self) -> Optional[int]: ...

    @property
    def probe_dport(self) -> Optional[int]: ...

    @property
    def probe_icmp_id(self) -> Optional[int]: ...

    def is_udp(self) -> bool: ...
    def is_tcp(self) -> bool: ...
    def is_icmp(self) -> bool: ...

class ScamperUdpprobeStop(enum.IntEnum):
    NoReason = cast(int, ...)
    Completed = cast(int, ...)
    Halted = cast(int, ...)
    Error = cast(int, ...)

class ScamperUdpprobeReply:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    @property
    def rx(self) -> datetime.datetime: ...

    @property
    def payload(self) -> Optional[bytes]: ...

    @property
    def ifname(self) -> Optional[str]: ...

class ScamperUdpprobeProbe:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperUdpprobeReply]: ...
    def __next__(self) -> ScamperUdpprobeReply: ...

    @property
    def tx(self) -> datetime.datetime: ...

    @property
    def sport(self) -> int: ...

    @property
    def reply_count(self) -> int: ...
    def reply(self, i: int) -> Optional[ScamperUdpprobeReply]: ...

class ScamperUdpprobe:
    def __init__(self, *args: object, **kwargs: object) -> None: ...

    def __iter__(self) -> Iterator[ScamperUdpprobeProbe]: ...
    def __next__(self) -> ScamperUdpprobeProbe: ...

    @property
    def inst(self) -> Optional[ScamperInst]: ...

    @property
    def list(self) -> Optional[ScamperList]: ...

    @property
    def cycle(self) -> Optional[ScamperCycle]: ...

    @property
    def userid(self) -> int: ...

    @property
    def start(self) -> datetime.datetime: ...

    def to_json(self) -> Optional[str]: ...

    @property
    def errmsg(self) -> Optional[str]: ...

    @property
    def stop_reason(self) -> ScamperUdpprobeStop: ...

    @property
    def stop_reason_str(self) -> str: ...

    @property
    def src(self) -> Optional[ScamperAddr]: ...

    @property
    def dst(self) -> Optional[ScamperAddr]: ...

    @property
    def sport(self) -> int: ...

    @property
    def dport(self) -> int: ...

    @property
    def wait_timeout(self) -> datetime.timedelta: ...

    @property
    def payload(self) -> Optional[bytes]: ...

    @property
    def probe_sent(self) -> int: ...
    def probe(self, i: int) -> Optional[ScamperUdpprobeProbe]: ...
    def replies(self) -> Iterator[ScamperUdpprobeReply]: ...

ScamperResponse: TypeAlias = Union[ScamperDealias, ScamperNeighbourdisc,
        ScamperHost, ScamperHttp, ScamperPing, ScamperSniff, ScamperSting,
        ScamperTbit, ScamperTrace, ScamperTracelb, ScamperUdpprobe]
ScamperObject: TypeAlias = Union[ScamperList, ScamperCycle, ScamperResponse]

class ScamperFile:
    def __init__(self,
                 filename: str,
                 mode: str = ...,
                 kind: Optional[str] = ...,
                 filter_types: List[Type[ScamperObject]] = ...) -> None: ...

    def __enter__(self) -> "ScamperFile": ...
    def __exit__(self,
                 exc_type: Optional[Type[BaseException]],
                 exc_value: Optional[BaseException],
                 traceback: Optional[types.TracebackType],
                 ) -> Optional[bool]: ...

    def __iter__(self) -> Iterator[ScamperObject]: ...

    def __next__(self) -> ScamperObject: ...

    @property
    def filetype(self) -> str: ...

    @property
    def filename(self) -> Optional[str]: ...

    def filter_types(self, filter_types: List[Type[ScamperObject]] = ...) -> None: ...

    def close(self) -> None: ...
    def read(self) -> ScamperObject: ...
    def write(self, obj: ScamperObject) -> None: ...

    def is_read(self) -> bool: ...
    def is_write(self) -> bool: ...

PT = TypeVar('PT')
class ScamperCtrl(Generic[PT]):
    morecb: Optional[Callable[["ScamperCtrl[PT]", ScamperInst, PT], None]]
    eofcb: Optional[Callable[["ScamperCtrl[PT]", ScamperInst, PT], None]]
    param: PT
    outfile: Optional[ScamperFile]

    def __init__(self,
                 meta: bool = ...,
                 morecb: Optional[Callable[["ScamperCtrl[PT]", ScamperInst, PT], None]] = ...,
                 eofcb: Optional[Callable[["ScamperCtrl[PT]", ScamperInst, PT], None]] = ...,
                 param: PT = ...,
                 unix: str = ...,
                 remote: str = ...,
                 remote_dir: str = ...,
                 mux: str = ...,
                 outfile: ScamperFile = ...
                 ) -> None: ...

    def __enter__(self) -> "ScamperCtrl[PT]": ...
    def __exit__(self,
                 exc_type: Optional[Type[BaseException]],
                 exc_value: Optional[BaseException],
                 traceback: Optional[types.TracebackType],
                 ) -> Optional[bool]: ...

    @property
    def instc(self) -> int: ...

    @property
    def taskc(self) -> int: ...

    def add_unix(self, path: str) -> ScamperInst: ...
    def add_inet(self, port: int, addr: Optional[str] = ...) -> ScamperInst: ...
    def add_remote(self, path: str) -> ScamperInst: ...
    def add_remote_dir(self, path: str) -> None: ...
    def add_mux(self, path: str) -> None: ...
    def add_vps(self, vps: Union[List[ScamperVp], ScamperVp]) -> List[ScamperInst]: ...
    def vps(self) -> List[ScamperVp]: ...

    def is_done(self) -> bool: ...
    def done(self) -> None: ...

    def instances(self) -> List[ScamperInst]: ...
    def exceptions(self) -> Generator[BaseException, None, None]: ...

    def poll(self,
             timeout: Union[datetime.timedelta, float, None] = ...,
             until: Optional[datetime.datetime] = ...
             ) -> Optional[ScamperResponse]: ...

    def responses(self,
                  timeout: Union[datetime.timedelta, float, None] = ...,
                  until: Optional[datetime.datetime] = ...
                  ) -> Generator[ScamperResponse, None, None]: ...

    def do_ally(self,
                dst1: Union[ScamperAddr, str],
                dst2: Union[ScamperAddr, str],
                fudge: Optional[int] = ...,
                icmp_sum: Optional[int] = ...,
                dport: Optional[int] = ...,
                sport: Optional[int] = ...,
                method: Optional[str] = ...,
                attempts: Optional[int] = ...,
                wait_probe: Union[datetime.timedelta, float, None] = ...,
                wait_timeout: Union[datetime.timedelta, float, None] = ...,
                userid: Optional[int] = ...,
                inst: Optional[ScamperInst] = ...,
                sync: Optional[bool] = ...
                ) -> Union[ScamperTask, ScamperDealias]: ...

    def do_dns(self,
               qname: str,
               server: Union[ScamperAddr, str, None] = ...,
               qclass: Optional[str] = ...,
               qtype: Optional[str] = ...,
               attempts: Optional[int] = ...,
               rd: Optional[bool] = ...,
               wait_timeout: Union[datetime.timedelta, float, None] = ...,
               tcp: Optional[bool] = ...,
               nsid: Optional[bool] = ...,
               ecs: Optional[bool] = ...,
               userid: Optional[int] = ...,
               inst: Union[ScamperInst, List[ScamperInst], None] = ...,
               sync: Optional[bool] = ...
               ) -> Union[ScamperHost, ScamperTask, List[ScamperTask]]: ...

    def do_http(self,
                dst: Union[ScamperAddr, str],
                url: str,
                headers: Optional[Dict[str, str]] = ...,
                insecure: Optional[bool] = ...,
                limit_time: Union[datetime.timedelta, float, None] = ...,
                userid: Optional[int] = ...,
                inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                sync: Optional[bool] = ...
                ) -> Union[ScamperHttp, ScamperTask, List[ScamperTask]]: ...

    def do_mercator(self,
                    dst: Union[ScamperAddr, str],
                    userid: Optional[int] = ...,
                    inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                    sync: Optional[bool] = ...
                    ) -> Union[ScamperDealias, ScamperTask, List[ScamperTask]]: ...

    def do_midardisc(self,
                     probedefs: Optional[List[ScamperDealiasProbedef]] = ...,
                     schedule: Optional[List[ScamperDealiasMidardiscRound]] = ...,
                     startat: Optional[datetime.datetime] = ...,
                     wait_timeout: Union[datetime.timedelta, float, None] = ...,
                     userid: Optional[int] = ...,
                     inst: Optional[ScamperInst] = ...,
                     sync: Optional[bool] = ...
                     ) -> Union[ScamperTask, ScamperDealias]: ...

    def do_midarest(self,
                    rounds: Optional[int] = ...,
                    wait_probe: Union[datetime.timedelta, float, None] = ...,
                    wait_round: Union[datetime.timedelta, float, None] = ...,
                    wait_timeout: Union[datetime.timedelta, float, None] = ...,
                    probedefs: Optional[List[ScamperDealiasProbedef]] = ...,
                    addrs: Optional[Sequence[Union[ScamperAddr, str]]] = ...,
                    userid: Optional[int] = ...,
                    inst: Optional[ScamperInst] = ...,
                    sync: Optional[bool] = ...
                    ) -> Union[ScamperTask, ScamperDealias]: ...

    def do_ping(self,
                dst: Union[ScamperAddr, str],
                tcp_ack: Optional[int] = ...,
                tcp_seq: Optional[int] = ...,
                attempts: Optional[int] = ...,
                icmp_id: Optional[int] = ...,
                icmp_seq: Optional[int] = ...,
                icmp_sum: Optional[int] = ...,
                dport: Optional[int] = ...,
                sport: Optional[int] = ...,
                wait_probe: Union[datetime.timedelta, float, None] = ...,
                ttl: Optional[int] = ...,
                mtu: Optional[int] = ...,
                stop_count: Optional[int] = ...,
                method: Optional[str] = ...,
                payload: Optional[bytes] = ...,
                rtr: Union[ScamperAddr, str, None] = ...,
                recordroute: Optional[bool] = ...,
                dltx: Optional[bool] = ...,
                size: Optional[int] = ...,
                src: Union[ScamperAddr, str, None] = ...,
                wait_timeout: Union[datetime.timedelta, float, None] = ...,
                tos: Optional[int] = ...,
                userid: Optional[int] = ...,
                inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                sync: Optional[bool] = ...
                ) -> Union[ScamperPing, ScamperTask, List[ScamperTask]]: ...

    def do_prefixscan(self,
                      near: Union[ScamperAddr, str],
                      far: Union[ScamperAddr, str],
                      prefixlen: int,
                      fudge: Optional[int] = ...,
                      icmp_sum: Optional[int] = ...,
                      dport: Optional[int] = ...,
                      sport: Optional[int] = ...,
                      method: Optional[str] = ...,
                      attempts: Optional[int] = ...,
                      wait_probe: Union[datetime.timedelta, float, None] = ...,
                      wait_timeout: Union[datetime.timedelta, float, None] = ...,
                      userid: Optional[int] = ...,
                      inst: Optional[ScamperInst] = ...,
                      sync: Optional[bool] = ...
                      ) -> Union[ScamperTask, ScamperDealias]: ...

    def do_radargun(self,
                    addrs: Optional[Sequence[Union[ScamperAddr, str]]] = ...,
                    rounds: Optional[int] = ...,
                    probedefs: Optional[List[ScamperDealiasProbedef]] = ...,
                    wait_probe: Union[datetime.timedelta, float, None] = ...,
                    wait_round: Union[datetime.timedelta, float, None] = ...,
                    wait_timeout: Union[datetime.timedelta, float, None] = ...,
                    userid: Optional[int] = ...,
                    inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                    sync: Optional[bool] = ...
                    ) -> Union[ScamperDealias, ScamperTask, List[ScamperTask]]: ...

    def do_sniff(self,
                 src: Union[ScamperAddr, str],
                 icmp_id: int,
                 limit_pkt_count: Optional[int] = ...,
                 limit_time: Union[datetime.timedelta, float, None] = ...,
                 userid: Optional[int] = ...,
                 inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                 sync: Optional[bool] = ...
                 ) -> Union[ScamperSniff, ScamperTask, List[ScamperTask]]: ...

    def do_tbit(self,
                dst: Union[ScamperAddr, str],
                method: Optional[str] = ...,
                url: Optional[str] = ...,
                userid: Optional[int] = ...,
                inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                sync: Optional[bool] = ...
                ) -> Union[ScamperTbit, ScamperTask, List[ScamperTask]]: ...

    def do_trace(self,
                 dst: Union[ScamperAddr, str],
                 confidence: Optional[int] = ...,
                 dport: Optional[int] = ...,
                 icmp_id: Optional[int] = ...,
                 icmp_sum: Optional[int] = ...,
                 firsthop: Optional[int] = ...,
                 gaplimit: Optional[int] = ...,
                 loops: Optional[int] = ...,
                 hoplimit: Optional[int] = ...,
                 pmtud: Optional[bool] = ...,
                 squeries: Optional[int] = ...,
                 ptr: Optional[bool] = ...,
                 payload: Optional[bytes] = ...,
                 method: Optional[str] = ...,
                 attempts: Optional[int] = ...,
                 all_attempts: Optional[bool] = ...,
                 rtr: Union[ScamperAddr, str, None] = ...,
                 sport: Optional[int] = ...,
                 src: Union[ScamperAddr, str, None] = ...,
                 tos: Optional[int] = ...,
                 wait_timeout: Union[datetime.timedelta, float, None] = ...,
                 wait_probe: Union[datetime.timedelta, float, None] = ...,
                 userid: Optional[int] = ...,
                 inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                 sync: Optional[bool] = ...
                 ) -> Union[ScamperTrace, ScamperTask, List[ScamperTask]]: ...

    def do_tracelb(self,
                   dst: Union[ScamperAddr, str],
                   confidence: Optional[int] = ...,
                   dport: Optional[int] = ...,
                   firsthop: Optional[int] = ...,
                   gaplimit: Optional[int] = ...,
                   method: Optional[str] = ...,
                   attempts: Optional[int] = ...,
                   ptr: Optional[bool] = ...,
                   rtr: Union[ScamperAddr, str, None] = ...,
                   sport: Optional[int] = ...,
                   tos: Optional[int] = ...,
                   wait_timeout: Union[datetime.timedelta, float, None] = ...,
                   wait_probe: Union[datetime.timedelta, float, None] = ...,
                   userid: Optional[int] = ...,
                   inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                   sync: Optional[bool] = ...
                   ) -> Union[ScamperTracelb, ScamperTask, List[ScamperTask]]: ...

    def do_udpprobe(self,
                    dst: Union[ScamperAddr, str],
                    dport: int,
                    payload: bytes,
                    attempts: Optional[int] = ...,
                    src: Union[ScamperAddr, str, None] = ...,
                    stop_count: Optional[int] = ...,
                    userid: Optional[int] = ...,
                    inst: Union[ScamperInst, List[ScamperInst], None] = ...,
                    sync: Optional[bool] = ...
                    ) -> Union[ScamperUdpprobe, ScamperTask, List[ScamperTask]]: ...
