/* 
 * Copyright 2016-2022, 2026 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MANAGER_COMMON_BLOCKWRITER_H
#define MANAGER_COMMON_BLOCKWRITER_H

#include <QBuffer>
#include <QDataStream>
#include <QIODevice>

class BlockWriter
{
    BlockWriter(const BlockWriter&) NO_METHOD; // no copy-ctor
    BlockWriter operator=(const BlockWriter&) NO_METHOD; // no copy-assign

public:
    BlockWriter(QIODevice *pdev) : dev(pdev), buffer(), stream()
    {
        buffer.open(QIODevice::WriteOnly);
        stream.setDevice(&buffer);
        stream << quint32(0); // placeholder; we will fill in real size later
    }

    ~BlockWriter()
    {
        // Fill in the real size.
        buffer.seek(0);
        stream << (quint32)buffer.size();

        // Write the buffer to the device.
        dev->write(buffer.buffer());
    }

    template <class T> BlockWriter &operator<<(const T &data)
	{ stream << data; return *this; }

private:
    QIODevice *dev;
    QBuffer buffer;
    QDataStream stream;
};

#endif // MANAGER_COMMON_BLOCKWRITER_H
