/* 
 * Copyright 2016-2022, 2026 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "../../config.h"
#include "spoof_qt.h"
#include "ActionButton.h"

void ActionButton::setAction(QAction *_action, QAction *_alt)
{
    if (action) {
	disconnect(action, nullptr, this, nullptr);
	disconnect(this, nullptr, action, nullptr);
	disconnect(this, nullptr, this, nullptr);
    }

    action = _action;
    alt = _alt;
    updateStatus();

    // When action status changes, so does button status.
    connect(action, &QAction::changed, this, &ActionButton::updateStatus);
    connect(action, &QAction::toggled, this, &ActionButton::setChecked);
    // Clicking the button triggers the action...
    connect(this, &ActionButton::clicked, action, &QAction::trigger);
    // ...and THEN swaps the current and alternate actions.
    connect(this, &ActionButton::clicked, this, &ActionButton::swap);
}

void ActionButton::swap()
{
    if (alt) setAction(alt, action);
}

void ActionButton::updateStatus()
{
    setCheckable(action->isCheckable());
    setEnabled(action->isEnabled());
    setIcon(action->icon());
    setText(action->text());
    setToolTip(action->toolTip());
    setStatusTip(action->statusTip());
    setWhatsThis(action->whatsThis());
    setFont(action->font());
    // We do NOT copy the "visible" property, so visibility can be managed via
    // the button.
}
